#!/usr/bin/env python3

import subprocess
from pathlib import Path
import json

def build_all(packages):
    results = {}
    for pkg_version in packages:
        code = subprocess.call([
            'cabal', 'new-build', pkg_version,
            '--allow-newer=base,template-haskell',
            '--ghc-option="-ddump-to-file -ddump-timings"'
            ])
        results[pkg_version] = code

    return results

if __name__ == '__main__':
    pkg_list = Path(__file__).parent / 'build-all.list'
    packages = pkg_list.read_text().split('\n')
    results = build_all(packages)
    json.dump(results, open('build-all.json', 'w'))
