#!/usr/bin/env bash

# This is a script to fetch and install a GHC tarball.
# Used by .gitlab-ci.yml.

set -e

# Check arguments
if [ -z "$GHC_TARBALL" ]; then
  echo "Set GHC_TARBALL to URL of GHC binary distribution"
  exit 1
fi

if [ -z "$INSTALL_PATH" ]; then
  echo "Set INSTALL_PATH to absolute directory in which to install GHC"
  exit 1
fi

tmp=$(mktemp -d tmp.XXXX)
cd $tmp

ghc=$INSTALL_PATH/bin/ghc
if [ -e "$ghc" ]; then
  echo "GHC already appears to be installed at $ghc."
else
  echo "Fetching and installing $GHC_TARBALL..."

  # Download it
  curl -Ls $GHC_TARBALL > artifacts.zip
  unzip artifacts.zip

  # Install it
  tar -xf ghc.tar.xz
  cd ghc-*
  ./configure --prefix=$INSTALL_PATH
  make install
  cd ..
fi

# Sanity check
cat >Test.hs <<EOF
main = putStrLn "Hello World!"
EOF
( $ghc Test.hs && ./Test ) || (
  echo "GHC seems not to work."
  echo "Are you sure you specified the correct GHC tarball for your system?"
  exit 1
)
echo "GHC seems to work properly."

# Cleanup
cd ..
rm -R $tmp

