{-# LANGUAGE QuasiQuotes #-}
{-# LANGUAGE MultiWayIf #-}
{-# LANGUAGE OverloadedStrings #-}

import Control.Monad

import Options.Applicative
import qualified TestPatches
import qualified MakeConstraints
import System.FilePath

mode :: Parser (IO ())
mode = hsubparser $ mconcat
  [ command "test-patches" $ info testPatches (progDesc "build patched packages")
  , command "make-constraints" $ info makeConstraints (progDesc "generate a cabal.constraints file")
  ]
  where
    testPatches = TestPatches.testPatches <$> TestPatches.config
    makeConstraints =
      f
      <$> option str (short 'w' <> long "with-compiler" <> metavar "GHC" <> help "ghc path")
      <*> argument str (metavar "DIR" <> help "patches directory")

    f ghcPath patchesDir = do
        let ghcPkgPath = replaceFileName ghcPath "ghc-pkg"
        MakeConstraints.makeConstraints patchesDir ghcPkgPath >>= print

main :: IO ()
main = do
  theMode <- execParser $ info (helper <*> mode) mempty
  theMode
