#! /usr/bin/env nix-shell
#! nix-shell -i bash
#! nix-shell -p curl jq nix

set -eufo pipefail

FILE=scripts/cabal-hashes.json

OWNER=$(jq -r '.owner' < "$FILE")
REPO=$(jq -r '.repo' < "$FILE")
BRANCH=$(jq -r '.branch' < "$FILE")

JSON=$(curl "https://api.github.com/repos/$OWNER/$REPO/branches/$BRANCH")
REV=$(echo "$JSON" | jq -r '.commit.sha')
MESSAGE=$(echo "$JSON" | jq -r '.commit.commit.message')
SHA256=$(nix-prefetch-url "https://github.com/$OWNER/$REPO/archive/$REV.tar.gz")
TJQ=$(jq '{owner: $owner, repo: $repo, branch: $branch, message: $message, rev: $rev, sha256: $sha256}' \
  --arg owner "$OWNER" \
  --arg repo "$REPO" \
  --arg branch "$BRANCH" \
  --arg message "$MESSAGE" \
  --arg rev "$REV" \
  --arg sha256 "$SHA256" \
  < "$FILE")
[[ $? == 0 ]] && echo "${TJQ}" >| "$FILE"
